# 💰 Mes Finances - Version Serveur avec Admin

Application web sécurisée pour analyser vos relevés bancaires avec authentification admin.

## 🔒 Fonctionnalités de sécurité

- ✅ **Authentification requise** - Login/mot de passe pour accéder
- ✅ **Sessions PHP** - Connexion sécurisée
- ✅ **Données sur VOTRE serveur** - Rien sur des serveurs tiers
- ✅ **Fichiers protégés** - .htaccess bloque l'accès direct aux données
- ✅ **Clé API cachée** - Jamais exposée côté client

## 📁 Structure des fichiers

```
expense-tracker-app/
├── index.html          # Application principale
├── config.php          # ⚠️ Configuration (À MODIFIER)
├── .htaccess           # Sécurité Apache
├── api/
│   ├── auth.php        # API authentification
│   ├── accounts.php    # API comptes bancaires
│   ├── statements.php  # API relevés
│   └── analyze.php     # API analyse IA
└── data/               # Données (créé automatiquement)
    ├── accounts.json
    └── statements.json
```

## ⚙️ Configuration (OBLIGATOIRE)

### Étape 1 : Modifier config.php

Ouvrez `config.php` et changez ces valeurs :

```php
// Identifiants Admin (CHANGEZ CES VALEURS !)
define('ADMIN_USERNAME', 'votre_nom_utilisateur');
define('ADMIN_PASSWORD', 'VotreMotDePasseSecurise123!');

// Clé secrète pour les sessions
define('SECRET_KEY', 'une-chaine-aleatoire-longue-et-unique');

// Clé API Gemini (GRATUIT)
define('GEMINI_API_KEY', 'votre_cle_gemini_ici');
```

### Étape 2 : Obtenir une clé API Gemini (GRATUIT)

1. Allez sur https://makersuite.google.com/app/apikey
2. Connectez-vous avec votre compte Google
3. Cliquez "Create API Key"
4. Copiez la clé dans `config.php`

## 🚀 Déploiement sur Namecheap

### Via cPanel (recommandé)

1. Connectez-vous à votre **cPanel Namecheap**
2. Ouvrez **File Manager**
3. Allez dans `public_html` (ou créez un sous-dossier comme `finances`)
4. **Uploadez TOUS les fichiers** en gardant la structure :
   ```
   public_html/
   └── finances/          (ou directement dans public_html)
       ├── index.html
       ├── config.php
       ├── .htaccess
       └── api/
           ├── auth.php
           ├── accounts.php
           ├── statements.php
           └── analyze.php
   ```
5. **IMPORTANT** : Le dossier `data/` est créé automatiquement

### Via FTP

1. Utilisez FileZilla ou autre client FTP
2. Hôte : `ftp.votre-domaine.com`
3. Uploadez dans `public_html/`

## 🔐 Première connexion

1. Accédez à `https://votre-domaine.com/` (ou `/finances/`)
2. Connectez-vous avec les identifiants définis dans `config.php`
3. C'est prêt !

## 🔄 Changer de provider IA

Dans `config.php`, modifiez :

```php
define('AI_PROVIDER', 'gemini');  // Options: 'gemini', 'openai', 'claude'
```

Et ajoutez la clé API correspondante.

| Provider | Gratuit | Support PDF |
|----------|---------|-------------|
| **Gemini** | ✅ Oui | ✅ Oui |
| OpenAI | ❌ Payant | ⚠️ Non |
| Claude | ❌ Payant | ✅ Oui |

## 🛡️ Sécurité

### Ce qui est protégé :
- ✅ `config.php` - Inaccessible depuis le web
- ✅ `data/*.json` - Inaccessible depuis le web
- ✅ Sessions PHP sécurisées
- ✅ Clé API jamais exposée au client

### Recommandations :
- Utilisez **HTTPS** (certificat SSL gratuit via Namecheap)
- Changez le mot de passe par défaut
- Utilisez un mot de passe fort (12+ caractères)

## 🔧 Dépannage

### "Erreur de connexion au serveur"
- Vérifiez que PHP est activé sur votre hébergement
- Vérifiez les permissions des fichiers (644 pour .php, 755 pour dossiers)

### "Clé API Gemini non configurée"
- Ouvrez `config.php` et ajoutez votre clé Gemini

### "Non autorisé" (401)
- Votre session a expiré, reconnectez-vous

### Les données ne se sauvegardent pas
- Vérifiez que le dossier `data/` a les permissions 755
- Créez-le manuellement si nécessaire

## 📱 Utilisation

1. **Ajouter un compte** : Cliquez "+ Ajouter un compte bancaire"
2. **Analyser un relevé** : Cliquez "Ajouter relevé" puis uploadez votre PDF
3. **Consulter l'historique** : Cliquez sur l'œil pour voir un relevé
4. **Se déconnecter** : Bouton en haut à droite

## 💾 Sauvegarde

Vos données sont dans le dossier `data/` :
- `accounts.json` - Liste des comptes
- `statements.json` - Tous les relevés analysés

**Sauvegardez régulièrement ces fichiers !**

## 📝 Licence

Usage personnel uniquement.
